/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//
// PROJECT NAME: vibration_sensor_dvcon14
//
// LIBRARY NAME: frontend
//
// MODULE NAME:  pga
//
// DESCRIPTION OF MODULE:
//      /* programmable gain amplifier */
//
// DESCRIPTION OF PORTS:
// in of type double
//      
// out of type double
//      
// k_in of type int
//      
// DESCRIPTION OF PARAMETER:
// v_supply of type double
//      
//
// this file was generated by 'sca_xml2h.xsl' StyleSheet
//
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _VIBRATION_SENSOR_FRONTEND_PGA_H_
#define _VIBRATION_SENSOR_FRONTEND_PGA_H_

#include <systemc-ams.h>


namespace vibration_sensor_namespace
{

SCA_TDF_MODULE(pga)
{
    // sca tdf ports
    sca_tdf::sca_in<double  > in;
    sca_tdf::sca_out<double  > out;
    sca_tdf::sc_in<int  > k_in;

    // parameters
    struct params
    {
        double  v_supply;

        params()
        {
            v_supply = 4.0;
        }
    } p;


    //methods
    void initialize();
    void processing();


    // constructor
    pga(sc_core::sc_module_name nm, params pa = params() ) : in("in"),
                                                       out("out"),
                                                       k_in("k_in"),
                                                       p(pa),
                                                       s(create_states())
    {
        accept_attribute_changes();



    }

    // states
    struct states;
    states& s;
    states* operator -> () { return &s; }

    private:
        static states& create_states();

};



} //end namespace vibration_sensor_namespace
using namespace vibration_sensor_namespace;


#endif

#ifdef ACCESS_MODULE_STATE_DECLARATION
#ifndef _VIBRATION_SENSOR_FRONTEND_PGA_CPP_
#define _VIBRATION_SENSOR_FRONTEND_PGA_CPP_
#include "pga.cpp"
#endif
#endif
