/*
 * Copyright (C) 2014 Torsten Maehne, Universit Pierre et Marie Curie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
////////////////////////////////////////////////////////////////////////////////
//
//   Version Id       : $Id$
//   Author           : karsten
//   Last Modified By : $Author$
//   Last Modified On : $Date$
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _VIBRATION_SENSOR_DVCON14_FRONTEND_ADC_H_
#include "adc.h"
#define FHG_INCLUDE_IMPLEMENTATION
#endif

namespace vibration_sensor_namespace
{

//-------------------------------------------------------------------//
// states                                                            //
//-------------------------------------------------------------------//
struct adc::states
{

    states()
    {
    }

};
//-------------------------------------------------------------------//

#ifdef FHG_INCLUDE_IMPLEMENTATION


//-------------------------------------------------------------------//
adc::states& adc::create_states() { return *(new states); }
//-------------------------------------------------------------------//


//////////////////////////////////////////////
// method initialize                        //
//////////////////////////////////////////////
void adc::initialize()
{
	  sc_assert((2 <= NBitsADC) && (NBitsADC <= 64));
	  sc_assert(p.v_max > 0.0);

}



//////////////////////////////////////////////
// method change_attributes                 //
//////////////////////////////////////////////
void adc::change_attributes()
{
	request_next_activation(clk.posedge_event());
}


//////////////////////////////////////////////
// method processing                        //
//////////////////////////////////////////////
void adc::processing()
{
	double v_in = in.read();
	if (v_in < -p.v_max)
	{
		out.write(-((1 << (NBitsADC - 1)) - 1));
	}
	else if (v_in > p.v_max)
	{
		out.write((1 << (NBitsADC - 1)) - 1);
	}
	else
	{
		sc_dt::sc_int<NBitsADC> q_v_in = lround(
				(v_in / p.v_max) * ((1 << (NBitsADC - 1)) - 1));

		out.write(q_v_in);
	}
}



#endif //#ifdef FHG_INCLUDE_IMPLEMENTATION

}  //end namespace vibration_sensor_dvcon14_namespace

//clear temporary defines
#undef FHG_INCLUDE_IMPLEMENTATION

