//----------------------------------------------------------------------
//   Copyright 2010-2014 Fraunhofer IIS/EAS
//   Copyright 2014 NXP B.V.
//   Copyright 2014 Universit Pierre et Marie Curie
//   All Rights Reserved
//
//   Licensed under the Apache License, Version 2.0 (the
//   "License"); you may not use this file except in
//   compliance with the License.  You may obtain a copy of
//   the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in
//   writing, software distributed under the License is
//   distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
//   CONDITIONS OF ANY KIND, either express or implied.  See
//   the License for the specific language governing
//   permissions and limitations under the License.
//----------------------------------------------------------------------
//
//   Original Author: Karsten Einwich Fraunhofer IIS/EAS Dresden
//
//   Created on: 16.02.2010
//
//----------------------------------------------------------------------

#include "adc_sd.h"

adc_sd::adc_sd(sc_core::sc_module_name nm)
{
  integ1 = 0.0;
  integ2 = 0.0;
}

void adc_sd::processing()
{
  double a = 0.5;
  double b = 0.5;
  double c = 1.0;

  // TODO 3.2: In the adc_sd.cpp file, in the processing() function,
  //           declare a local bool variable output. Assign it with
  //           true (if integ2>=0.0) or false (if integ2<0.0). Also
  //           declare a local double variable feedback.  Assign it
  //           with 1.0 (if integ2>=0.0) or -1.0 (if
  //           integ2<0.0).Write the output value to the out TDF port.

  // TODO 3.3: In the adc_sd.cpp file, in the processing() function,
  //           with help of the Figure, declare and assign s1, k1, s2,
  //           k2, k3, s3, s4 in the right order. Some assignements
  //           (i.e. s2 or s3) depend on the previous/integrated
  //           values, integ1 and integ2 that are just used as Right
  //           Hand Sides at this stage of the processing() function.

  // TODO 3.4: In the adc_sd.cpp file, in the processing() function,
  //           complete/resolve the feedback loops with the respective
  //           assignments of the integ1 and integ2 member variables
  //           with the s4 and s2 values that have just been computed.
}

void adc_sd::ac_processing()
{
  sca_ac(out) = 0.25 / (sca_ac_z(2) - 1.5 * sca_ac_z() + 0.75) * sca_ac(in);
}
