/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test vcd tracing for sc_in<T>, sc_out<T> and sc_signal<T>
// for SystemC data types as defined in the AMS LRM and 1666 LRM

// NOTE: this unit test contains fixed point calculations and needs the
// additional SC_INCLUDE_FX define BEFORE the actual systemc-ams include!

#define SC_INCLUDE_FX
#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE(my_source)
{
  sc_core::sc_out<sc_dt::sc_logic> out_sc_logic;
  sc_core::sc_out<sc_dt::sc_int<10> > out_sc_int;
  sc_core::sc_out<sc_dt::sc_uint<10> > out_sc_uint;
  sc_core::sc_out<sc_dt::sc_signed> out_sc_signed;
  sc_core::sc_out<sc_dt::sc_unsigned> out_sc_unsigned;
  sc_core::sc_out<sc_dt::sc_bv<4> > out_sc_bv;
  sc_core::sc_out<sc_dt::sc_lv<4> > out_sc_lv;
  sc_core::sc_out< sc_dt::sc_fixed<16, 8> > out_sc_fixed;
  sc_core::sc_out< sc_dt::sc_ufixed<16, 8> > out_sc_ufixed;

  sc_dt::sc_signed m_sc_signed;
  sc_dt::sc_unsigned m_sc_unsigned;;

  SC_CTOR(my_source) :
   out_sc_logic("out_sc_logic"),
   out_sc_int("out_sc_int"),
   out_sc_uint("out_sc_uint"),
   out_sc_signed("out_sc_signed"),
   out_sc_unsigned("out_sc_unsigned"),
   out_sc_bv("out_sc_bv"),
   out_sc_lv("out_sc_lv"),
   out_sc_fixed("out_sc_fixed"),
   out_sc_ufixed("out_sc_ufixed")
  {
    SC_THREAD(processing);
  }

  void processing()
  {
    while (true)
    {
      out_sc_logic.write( sc_dt::SC_LOGIC_1 );
      out_sc_int.write( 3 );
      out_sc_uint.write( 7 );
      m_sc_signed = 3;
      m_sc_unsigned = 7;
      out_sc_signed.write( m_sc_signed );
      out_sc_unsigned.write( m_sc_unsigned );
      out_sc_bv = "0011"; // write using operator=
      out_sc_lv = "1100"; // write using operator=
      out_sc_fixed.write( 254.5 );
      out_sc_ufixed.write( 254.5 );
      wait(3.2, sc_core::SC_MS);

      out_sc_logic.write( sc_dt::SC_LOGIC_0 );
      out_sc_int.write( -3 );
      out_sc_uint.write( 5 );
      m_sc_signed = -3;
      m_sc_unsigned = 5;
      out_sc_signed.write( m_sc_signed );
      out_sc_unsigned.write( m_sc_unsigned );
      out_sc_bv = "1111"; // write using operator=
      out_sc_lv = "1110"; // write using operator=
      out_sc_fixed.write( 3.303 );
      out_sc_ufixed.write( 4.404 );
      wait(0.8, sc_core::SC_MS);
    }
  }
};

SC_MODULE(my_sink)
{
  sc_core::sc_in<sc_dt::sc_logic> in_sc_logic;
  sc_core::sc_in<sc_dt::sc_int<10> > in_sc_int;
  sc_core::sc_in<sc_dt::sc_uint<10> > in_sc_uint;
  sc_core::sc_in<sc_dt::sc_signed> in_sc_signed;
  sc_core::sc_in<sc_dt::sc_unsigned> in_sc_unsigned;
  sc_core::sc_in<sc_dt::sc_bv<4> > in_sc_bv;
  sc_core::sc_in<sc_dt::sc_lv<4> > in_sc_lv;
  sc_core::sc_in<sc_dt::sc_fixed<16, 8> > in_sc_fixed;
  sc_core::sc_in<sc_dt::sc_ufixed<16, 8> > in_sc_ufixed;

  SC_CTOR(my_sink) :
   in_sc_logic("in_sc_logic"),
   in_sc_int("in_sc_int"),
   in_sc_uint("in_sc_uint"),
   in_sc_signed("in_sc_signed"),
   in_sc_unsigned("in_sc_unsigned"),
   in_sc_bv("in_sc_bv"),
   in_sc_lv("in_sc_lv"),
   in_sc_fixed("in_sc_fixed"),
   in_sc_ufixed("in_sc_ufixed")
  { }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<sc_dt::sc_logic> sig_sc_logic;
  sc_core::sc_signal<sc_dt::sc_int<10> > sig_sc_int;
  sc_core::sc_signal<sc_dt::sc_uint<10> > sig_sc_uint;
  sc_core::sc_signal<sc_dt::sc_signed> sig_sc_signed;
  sc_core::sc_signal<sc_dt::sc_unsigned> sig_sc_unsigned;
  sc_core::sc_signal<sc_dt::sc_bv<4> > sig_sc_bv;
  sc_core::sc_signal<sc_dt::sc_lv<4> > sig_sc_lv;
  sc_core::sc_signal<sc_dt::sc_fixed<16, 8> > sig_sc_fixed;
  sc_core::sc_signal<sc_dt::sc_ufixed<16, 8> > sig_sc_ufixed;

  my_source src("src");
    src.out_sc_logic( sig_sc_logic );
    src.out_sc_int( sig_sc_int );
    src.out_sc_uint( sig_sc_uint );
    src.out_sc_signed( sig_sc_signed );
    src.out_sc_unsigned( sig_sc_unsigned );
    src.out_sc_bv( sig_sc_bv );
    src.out_sc_lv( sig_sc_lv );
    src.out_sc_fixed( sig_sc_fixed );
    src.out_sc_ufixed( sig_sc_ufixed );

  my_sink sink("sink");
    sink.in_sc_logic( sig_sc_logic );
    sink.in_sc_int( sig_sc_int );
    sink.in_sc_uint( sig_sc_uint );
    sink.in_sc_signed( sig_sc_signed );
    sink.in_sc_unsigned( sig_sc_unsigned );
    sink.in_sc_bv( sig_sc_bv );
    sink.in_sc_lv( sig_sc_lv );
    sink.in_sc_fixed( sig_sc_fixed );
    sink.in_sc_ufixed( sig_sc_ufixed );

  sca_util::sca_trace_file* tf = sca_util::sca_create_vcd_trace_file("test01");

  sca_util::sca_trace(tf, sig_sc_logic, "sig_sc_logic");
  sca_util::sca_trace(tf, sig_sc_int, "sig_sc_int");
  sca_util::sca_trace(tf, sig_sc_uint, "sig_sc_uint");
  sca_util::sca_trace(tf, sig_sc_signed, "sig_sc_signed");
  sca_util::sca_trace(tf, sig_sc_unsigned, "sig_sc_unsigned");
  sca_util::sca_trace(tf, sig_sc_bv, "sig_sc_bv");
  sca_util::sca_trace(tf, sig_sc_lv, "sig_sc_lv");
  sca_util::sca_trace(tf, sig_sc_fixed, "sig_sc_fixed");
  sca_util::sca_trace(tf, sig_sc_ufixed, "sig_sc_ufixed");

  sca_util::sca_trace(tf, src.out_sc_logic, "src.out_sc_logic");
  sca_util::sca_trace(tf, src.out_sc_int, "src.out_sc_int");
  sca_util::sca_trace(tf, src.out_sc_uint, "src.out_sc_uint");
  sca_util::sca_trace(tf, src.out_sc_signed, "src.out_sc_signed");
  sca_util::sca_trace(tf, src.out_sc_unsigned, "src.out_sc_unsigned");
  sca_util::sca_trace(tf, src.out_sc_bv, "src.out_sc_bv");
  sca_util::sca_trace(tf, src.out_sc_lv, "src.out_sc_lv");
  sca_util::sca_trace(tf, src.out_sc_fixed, "src.out_sc_fixed");
  sca_util::sca_trace(tf, src.out_sc_ufixed, "src.out_sc_ufixed");

  sca_util::sca_trace(tf, sink.in_sc_logic, "sink.in_sc_logic");
  sca_util::sca_trace(tf, sink.in_sc_int, "sink.in_sc_int");
  sca_util::sca_trace(tf, sink.in_sc_uint, "sink.in_sc_uint");
  sca_util::sca_trace(tf, sink.in_sc_signed, "sink.in_sc_signed");
  sca_util::sca_trace(tf, sink.in_sc_unsigned, "sink.in_sc_unsigned");
  sca_util::sca_trace(tf, sink.in_sc_bv, "sink.in_sc_bv");
  sca_util::sca_trace(tf, sink.in_sc_lv, "sink.in_sc_lv");
  sca_util::sca_trace(tf, sink.in_sc_fixed, "sink.in_sc_fixed");
  sca_util::sca_trace(tf, sink.in_sc_ufixed, "sink.in_sc_ufixed");

  // for reference, we also make a VCD file using the core SystemC lib...

  sc_core::sc_trace_file* tf2 = sc_core::sc_create_vcd_trace_file("test01_systemc");

  sc_core::sc_trace(tf2, sig_sc_logic, "sig_sc_logic");
  sc_core::sc_trace(tf2, sig_sc_int, "sig_sc_int");
  sc_core::sc_trace(tf2, sig_sc_uint, "sig_sc_uint");
  sc_core::sc_trace(tf2, sig_sc_signed, "sig_sc_signed");
  sc_core::sc_trace(tf2, sig_sc_unsigned, "sig_sc_unsigned");
  sc_core::sc_trace(tf2, sig_sc_bv, "sig_sc_bv");
  sc_core::sc_trace(tf2, sig_sc_lv, "sig_sc_lv");
  sc_core::sc_trace(tf2, sig_sc_fixed, "sig_sc_fixed");
  sc_core::sc_trace(tf2, sig_sc_ufixed, "sig_sc_ufixed");

  sc_core::sc_trace(tf2, src.out_sc_logic, "src.out_sc_logic");
  sc_core::sc_trace(tf2, src.out_sc_int, "src.out_sc_int");
  sc_core::sc_trace(tf2, src.out_sc_uint, "src.out_sc_uint");
  sc_core::sc_trace(tf2, src.out_sc_signed, "src.out_sc_signed");
  sc_core::sc_trace(tf2, src.out_sc_unsigned, "src.out_sc_unsigned");
  sc_core::sc_trace(tf2, src.out_sc_bv, "src.out_sc_bv");
  sc_core::sc_trace(tf2, src.out_sc_lv, "src.out_sc_lv");
  sc_core::sc_trace(tf2, src.out_sc_fixed, "src.out_sc_fixed");
  sc_core::sc_trace(tf2, src.out_sc_ufixed, "src.out_sc_ufixed");

  sc_core::sc_trace(tf2, sink.in_sc_logic, "sink.in_sc_logic");
  sc_core::sc_trace(tf2, sink.in_sc_int, "sink.in_sc_int");
  sc_core::sc_trace(tf2, sink.in_sc_uint, "sink.in_sc_uint");
  sc_core::sc_trace(tf2, sink.in_sc_signed, "sink.in_sc_signed");
  sc_core::sc_trace(tf2, sink.in_sc_unsigned, "sink.in_sc_unsigned");
  sc_core::sc_trace(tf2, sink.in_sc_bv, "sink.in_sc_bv");
  sc_core::sc_trace(tf2, sink.in_sc_lv, "sink.in_sc_lv");
  sc_core::sc_trace(tf2, sink.in_sc_fixed, "sink.in_sc_fixed");
  sc_core::sc_trace(tf2, sink.in_sc_ufixed, "sink.in_sc_ufixed");

  sc_core::sc_start(10, sc_core::SC_MS);

  sca_util::sca_close_vcd_trace_file(tf);
  sc_core::sc_close_vcd_trace_file(tf2);

  TEST_LABEL_END;

  return 0;
}
