/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test time propagation acc. to 4.1.3.1.2.
// M.get_timestep() = P.get_timestep() * P.get_rate()

// In this example
// mod_a: 2.0 =  1.0 * 2
// mod_b: 1.0 =  1.0 * 1
// results in cluster execution schedule { A B B }

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( mod_a )
{
  sca_tdf::sca_out<double> out;

  void processing()
  {
    std::cout << "A" << std::endl;
  }

  void set_attributes()
  {
    out.set_timestep(1.0, sc_core::SC_MS);
    out.set_rate(2);

    set_timestep(2.0, sc_core::SC_MS);
  }

  SCA_CTOR( mod_a ) {}
};

SCA_TDF_MODULE( mod_b )
{
  sca_tdf::sca_in<double> in;

  void processing()
  {
    std::cout << "B" << std::endl;
  }

  void set_attributes()
  {
    in.set_timestep(1.0, sc_core::SC_MS);
    in.set_rate(1);

    set_timestep(1.0, sc_core::SC_MS);
  }

  SCA_CTOR( mod_b ) {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;

  mod_a a("a");
   a.out(sig1);

  mod_b b("b");
   b.in(sig1);

  sc_core::sc_start(2.0, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
