/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test TDF module with virtual register_processing method

#include <systemc-ams>
#include "test_utilities.h"

class tdf_module_base : public sca_tdf::sca_module
{
public:

  virtual void set_attributes() {}

  virtual void initialize() {}

  virtual void my_processing() {}

  tdf_module_base()
  {
    ptr = static_cast<sca_module_method>(&tdf_module_base::my_processing);
    register_processing( ptr );
  }

private:
  sca_module_method ptr; // pointer to new method
};

class tdf_module : public tdf_module_base
{
public:
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    set_timestep(1, sc_core::SC_MS);
  }

  void initialize()
  {
    std::cout << "initialize called from " << name() << " at " << get_time() << std::endl;
    std::cout << "module time step : " << get_timestep() << std::endl;
  }

  void my_processing()
  {
    std::cout << "my_processing called from " << name() << " at " << get_time() << std::endl;
  }

  tdf_module( sc_core::sc_module_name ) : out("out") {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig;

  tdf_module mod1("mod1");
  mod1.out(sig);

  sc_core::sc_start(10, sc_core::SC_MS);

  TEST_LABEL_END;

  return 0;
}
