/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test kind() function, constructor arguments, and default values of sca_eln::sca_tdf_rswitch

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_tdf_rswitch i_tdf_rswitch("i_tdf_rswitch");

  std::cout << "i_tdf_rswitch.kind(): " << i_tdf_rswitch.kind() << std::endl;

  std::cout << "i_tdf_rswitch.p.kind(): " << i_tdf_rswitch.p.kind() << std::endl;
  std::cout << "i_tdf_rswitch.p.name(): " << i_tdf_rswitch.p.name() << std::endl;

  std::cout << "i_tdf_rswitch.n.kind(): " << i_tdf_rswitch.n.kind() << std::endl;
  std::cout << "i_tdf_rswitch.n.name(): " << i_tdf_rswitch.n.name() << std::endl;

  std::cout << "i_tdf_rswitch.ctrl.kind(): " << i_tdf_rswitch.ctrl.kind() << std::endl;
  std::cout << "i_tdf_rswitch.ctrl.name(): " << i_tdf_rswitch.ctrl.name() << std::endl;

  std::cout << "i_tdf_rswitch.ron.kind(): " << i_tdf_rswitch.ron.kind() << std::endl;
  std::cout << "i_tdf_rswitch.ron.name(): " << i_tdf_rswitch.ron.name() << std::endl;
  std::cout << "default value of ron: " << i_tdf_rswitch.ron << std::endl;

  std::cout << "i_tdf_rswitch.roff.kind(): " << i_tdf_rswitch.roff.kind() << std::endl;
  std::cout << "i_tdf_rswitch.roff.name(): " << i_tdf_rswitch.roff.name() << std::endl;
  if (i_tdf_rswitch.roff == sca_util::SCA_INFINITY)
    std::cout << "default value of roff is  sca_util::SCA_INFINITY"   << std::endl;
  else
    std::cout << "Error default value of roff is  not sca_util::SCA_INFINITY: "  << i_tdf_rswitch.roff << std::endl;

  std::cout << "i_tdf_rswitch.off_state.kind(): " << i_tdf_rswitch.off_state.kind() << std::endl;
  std::cout << "i_tdf_rswitch.off_state.name(): " << i_tdf_rswitch.off_state.name() << std::endl;
  std::cout << "default value of off_state: " << i_tdf_rswitch.off_state << std::endl;

  TEST_LABEL_END;

  return 0;
}
