/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/
// constant reference source

#ifndef REF_SRC_H
#define REF_SRC_H

#include <systemc-ams>

SCA_TDF_MODULE(ref_src)
{
  sca_tdf::sca_out<double> out;

  ref_src( sc_core::sc_module_name nm, double value_= 1.0, sca_core::sca_time t_step_ = sca_core::sca_time(0.05, sc_core::SC_MS) )
  : out("out"), value(value_), t_step(t_step_)
  {}

  void set_attributes()
  {
    out.set_timestep(t_step);
  }

  void processing()
  {
    out.write(value);
  }

private:
  double value;
  sca_core::sca_time t_step;
};

#endif // REF_SRC_H

/*
 * Local Variables:
 * mode: C++
 * End:
 */
