/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test member functions set_timeoffset() and get_timeoffset()
// of ports of class sca_tdf::sca_de::sca_in

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( ramp )
{
  sca_tdf::sca_out<double> out;

  void set_attributes()
  {
    accept_attribute_changes();
    does_attribute_changes();
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    val = get_time().to_seconds();
    out.write(val);
    activations++;
  }

  void change_attributes()
  {
    if (activations == 3)
      request_next_activation( sc_core::sc_get_time_resolution() );
  }

  SCA_CTOR( ramp ) : out("out"), val(0.0), activations(0)
  {}

 private:
  double val;
  int activations;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_set_time_resolution(1.0, sc_core::SC_FS);

  sca_tdf::sca_signal<double> tdf_sig;

  ramp r("r");
  r.out(tdf_sig);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("tdf_ramp");
  sca_util::sca_trace(atf, tdf_sig, "tdf_sig");
  
  sc_core::sc_start(10.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("tdf_ramp", 1);
  
  TEST_LABEL_END;

  return 0;
}
