# Running the SystemC AMS Regression Suite on Windows

To run the regression tests on Windows, a basic Un*x shell environment like

  - Cygwin 1.3.x, or later       (http://cygwin.org)
  - MinGW/MSYS 1.0.14, or later  (http://mingw.org)

is required, even when using the Microsoft Visual C++ compiler (CL).
The test script uses the command-line version of the Visual C++ compiler.

In the instructions that follow, it is assumed that you have installed
Visual Studio 2015, other versions later than Visual C++ 2015
will also work as documented in the SystemC AMS library itself.

## Installing SystemC and SystemC AMS

When you install SystemC and SystemC AMS, make sure that the folder that 
contains the Visual C++ project has the correct name for the version of 
Visual C++ you are using.  This can be done by copying the default `msvc*` folder to the
appropriate location before upgrading the solution/project files).

    For Visual C++ 2015 : msvc14
    For Visual C++ 2019 : msvc16
    For Visual C++ 2022 : msvc17

## Running the regressions

1) The INCLUDE, LIB, and PATH environment variables must be set in Windows 
   before launching a Cygwin or MinGW shell.

   The quickest way to do this is to launch a Visual C++ 2015 command prompt:

     Start
       > Programs
       > Microsoft Visual Studio 2015
       > Visual Studio Command Prompt (2015)

   Alternatively, you can open a plain command prompt and use the
   `scripts\vsvars.bat` file to setup the Visual C++ tools environment.
   With this batch file, you can specify the version and the platform to
   use via additional command-line options given to vsvars.bat, e.g.

   ```
   cd c:\systemc_ams_regressions\scripts

   vsvars.bat [arch]               # load MSVC 2015 for [arch]
   vsvars.bat [version]            # load MSVC [version] for x86
   vsvars.bat [version] [platform] # load MSVC [version] for [platform]

   vsvars.bat 2019 amd64  # load 64-bit tools for MSVC 16.0
   vsvars.bat 17.0        # load default (x86) tools for MSVC 2022
   vsvars.vat x86_amd64   # load x64 cross-tools for MSVC 2015
   ```

2) From that command prompt, launch a shell for your Un*x shell compatibility
   layer (Cygwin or MinGW):

   ```
   Cygwin:
     c:\cygwin\cygwin.bat

   MinGW:
     c:\MinGW\msys\1.0\msys.bat
   ```

The remaining commands are typed at the shell prompt that should
have now appeared in a new window.

3) The `SYSTEMC_HOME` and `SYSTEMC_AMS_HOME` environment variables must be set 
   to SystemC and SystemC AMS install directories, respectively.
   For example, for a SystemC installation located at `c:\systemc-2.3.4` and 
   SystemC AMS installation located at `c:\systemc-ams-2.3.4`

   MinGW  (drop drive colon and use '/' instead of '\'):
   ```
   export SYSTEMC_HOME=/c/systemc-2.3.4
   export SYSTEMC_AMS_HOME=/c/systemc-ams-2.3.4
   ```
   
   Cygwin (additionally, paths are prefixed with '/cygdrive'):
   ```
   export SYSTEMC_HOME=/cygdrive/c/systemc-2.3.4
   export SYSTEMC_AMS_HOME=/cygdrive/c/systemc-ams-2.3.4
   ```

4) Set the compiler to use Visual C++:
   (otherwise the Cygwin/MinGW GNU C++ compiler will be used by default)
   ```
   export CXX=cl
   ```

5) Change to the systemc-ams-regressions folder and create a directory to
   hold the test results and cd into it, e.g.:

   ```
   cd systemc-ams-regressions
   mkdir run
   cd run
   ```

6) Run the verify-ams.pl script as described in the main README, e.g.:

   ```
   ../scripts/verify-ams.pl systemc-ams     (runs all SystemC tests using release library)
   ../scripts/verify-ams.pl -g systemc-ams  (runs all SystemC tests using debug library)
   ```

7) After all tests are complete, the output summary should show 100% passes.
