// File test_file_gen.cpp

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <cstring>

using namespace std;

enum command_type {
	READ,
	WRITE,
	READ_WRITE
};

void generate_test_file(const char *filename, int n_cycles, command_type cmd, unsigned int addr_low, unsigned int addr_high, int thread_id, int len, double rate) {
	ofstream fout(filename);

	int count = 0;
	for (int i = 0; i < n_cycles; ++i) {
		if ((rand() * rand()) % int(double(len * 100) / rate) / 100) continue;
		count++;

		if (cmd == READ)
			fout << ".r ";
		else if (cmd == WRITE)
			fout << ".w ";
		else if (rand() % 2)
			fout << ".r ";
		else
			fout << ".w ";

		fout << i << " ";

		unsigned int addr = (addr_low + (rand() * rand()) % (addr_high - addr_low - 4 * len + 1)) & (~0x3);

		fout << "0x" << hex << addr << dec << " ";

		fout << thread_id << " ";
		
		fout << len << endl;
	}

	fout << ".e\n";

	cout << "Number of transactions: " << count << endl;
}

void generate_test_file_mt(const char *filename, int n_cycles) {
	command_type cmd[4] = { READ, WRITE, READ, WRITE };
	unsigned int addr_low[4] = { 0x0, 0x4000, 0x8000, 0xc000 };
	unsigned int addr_high[4] = { 0x4000, 0x8000, 0xc000, 0x10000 };
	unsigned int len[4] = { 16, 16, 8, 8 };
	double rate[4] = { 0.12, 0.12, 0.12, 0.12 };

	ofstream fout(filename);

	for (int i = 0; i < n_cycles; ++i) {
		for (int id = 0; id < 4; ++id) {
			if ((rand() % int(double(len[id] * 100) / rate[id])) / 100) continue;

			if (cmd[id] == READ)
				fout << ".r ";
			else if (cmd[id] == WRITE)
				fout << ".w ";
			else if (rand() % 2)
				fout << ".r ";
			else
				fout << ".w ";

			fout << i << " ";

			unsigned int addr = (addr_low[id] + rand() % (addr_high[id] - addr_low[id])) & (~0x3);
			cout << "rand: " << hex << addr << dec << endl;

			fout << "0x" << hex << addr << dec << " ";

			fout << id << " ";
			
			fout << len[id] << endl;
		}
	}

	fout << ".e\n";
}

int main(int argc, char *argv[]) {
	if (argc < 7) {
		cerr << "Usage:\n";
		cerr << "test_file_gen filename cycles r|w|rw addr_range len rate\n";
		exit(1);
	}

	const char *filename = argv[1];
	int cycles = atoi(argv[2]);
	command_type cmd;
	if (!strcmp(argv[3], "r"))
		cmd = READ;
	else if (!strcmp(argv[3], "w"))
		cmd = WRITE;
	else
		cmd = READ_WRITE;
	unsigned int addr_high = 0x4000 * atoi(argv[4]);
	int len = atoi(argv[5]);
	double rate = atof(argv[6]);

	generate_test_file(filename, cycles, cmd, 0, addr_high, 0, len, rate);

	return 0;
}