/*
 * Created on 20.7.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.xml.test;

import java.io.IOException;
import java.net.URISyntaxException;

import javax.xml.bind.JAXBException;

import fi.cpu.ui.xml.UIConfigMarshaller;
import fi.cpu.xml.bind.uiconfig.ControlViewType;
import fi.cpu.xml.bind.uiconfig.MainWindowType;
import fi.cpu.xml.bind.uiconfig.ObjectFactory;
import fi.cpu.xml.bind.uiconfig.UIConfigType;
import fi.cpu.xml.bind.uiconfig.WindowSizeType;

/**
 * @author Timo Vanhatupa
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class UIConfigTest {

	public static void main(String[] args) throws JAXBException, IOException, URISyntaxException {

		UIConfigMarshaller m = new UIConfigMarshaller();
		ObjectFactory of = m.getObjectFactory();
		
		UIConfigType uiconfig = m.getObjectFactory().createUIConfig();
		uiconfig.setMainWindow(of.createMainWindowType());
		uiconfig.setControlView(of.createControlViewType());
		uiconfig.setMonitorView(of.createMonitorViewType());
			
		MainWindowType mainWindow = uiconfig.getMainWindow();
		mainWindow.setWindowSize(of.createWindowSizeType());
		
		WindowSizeType windowSize = mainWindow.getWindowSize();
		windowSize.setX(200);
		windowSize.setY(100);
		
		ControlViewType controlView = uiconfig.getControlView();
		controlView.setConfiguration(of.createConfigurationType());
		
		m.saveUIConfig("uiconfig1.xml", uiconfig);

		UIConfigType loadedUIConfig = m.loadUIConfig("uiconfig1.xml");
		System.out.println("Window size.x=" + loadedUIConfig.getMainWindow().getWindowSize().getX());
	}
}