/*
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package fi.cpu.table;

import java.util.Vector;

import javax.swing.table.DefaultTableModel;

/**
 * Modified TabelModel class extending DefaultTableModel class to
 * prevent sorting columns always as Strings but rather as their
 * real class type. In practice this makes e.g. Integers sorting
 * correctly and more efficiently.
 */
public class SortableTableModel extends DefaultTableModel {

	public SortableTableModel() {

	}

	public SortableTableModel(int arg0, int arg1) {
		super(arg0, arg1);
	}

	public SortableTableModel(Vector arg0, int arg1) {
		super(arg0, arg1);
	}

	public SortableTableModel(Object[] arg0, int arg1) {
		super(arg0, arg1);
	}

	public SortableTableModel(Vector arg0, Vector arg1) {
		super(arg0, arg1);
	}

	public SortableTableModel(Object[][] arg0, Object[] arg1) {
		super(arg0, arg1);
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.AbstractTableModel#getColumnClass(int)
	 */
	@Override
	public Class<?> getColumnClass(int index) {
		// Find out the class of the column from an object
		// in the first row of table model.
		return getValueAt(0, index).getClass();
	}

}
