/**
 * CVS:
 * $Id: SignalsTableHeaderRenderer.java 1399 2010-08-26 13:56:45Z lehton87 $
 * 
 * File:    SignalsTableHeaderRenderer.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 22.11.2006
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.table;

import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;

import fi.cpu.Settings;
import fi.cpu.data.Model;
import fi.cpu.data.ModelNode;
import fi.cpu.data.ProcessingElement;
import fi.cpu.data.Thread;
import fi.cpu.ui.MainWindow;


/**
 * A renderer class for signal table headers.
 */
public class SignalsTableHeaderRenderer extends DefaultTableCellRenderer {
	protected static final Color[] BG_COLORS;
	protected static final Color DEFAULT_BG;
	
	static {
		JPanel panel = new JPanel();
		DEFAULT_BG = panel.getBackground();
		
		int red = 0;
		int green = 0;
		int blue = 0;
		
		red = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_RED_1") );
		green = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_GREEN_1") );
		blue = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_BLUE_1") );
		
		Color c1 = new Color(red, green, blue);
		
		red = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_RED_2") );
		green = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_GREEN_2") );
		blue = Integer.parseInt( Settings.getAttributeValue("SIGNAL_TABLE_COLOR_BLUE_2") );
		
		Color c2 = new Color(red, green, blue);
		
		BG_COLORS = new Color[] {c1, c2};
	}
	
	protected Vector<Integer> pCounts;
	protected SignalsTableModel tableModel;
	
	
	
	/**
	 * Creates a new SignalsTableHeaderRenderer
	 */
	public SignalsTableHeaderRenderer(SignalsTableModel model) {
		super();
		pCounts = new Vector<Integer>();
		tableModel = model;
		tableModel.addTableModelListener(new MyTableModelListener());
	}
	
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		if (column == 0 && row == -1) {
			setBackground(DEFAULT_BG);
		} else {
			// determine the color for the cell
			int processCount = 0;
			int oldProcessCount = 0;
			int processorNumber = 0;
			int pesWithProcesses = 0;
			
			for (int i=0; i<pCounts.size(); ++i) {
				oldProcessCount = processCount;
				processCount += pCounts.get(i);
				
				if (pCounts.get(i) > 0) {
					++pesWithProcesses;
				}
				
				if (column >= oldProcessCount+1 && column <= processCount
						|| row >= oldProcessCount && row < processCount) {
						// the cell belongs to processor number i
						processorNumber = i;
						break;
				}
				
			}
//			setBackground(BG_COLORS[processorNumber%BG_COLORS.length]);
			setBackground(BG_COLORS[pesWithProcesses%BG_COLORS.length]);
		}

		Component comp = super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
		if (row == -1 && comp instanceof JComponent) {
			JComponent jComp = (JComponent) comp;
			jComp.setBorder(BorderFactory.createEtchedBorder());
		}
		return comp;
	}
	
	
	/**
	 * Listener for TableModelEvents.
	 */
	private class MyTableModelListener implements TableModelListener {
		public void tableChanged(TableModelEvent e) {
			int firstRow = e.getFirstRow();
			if (firstRow == TableModelEvent.HEADER_ROW) {
				pCounts.clear();
				
				Model peModel = MainWindow.getInstance().getConfiguration().getPeModel();
				Iterator<ModelNode> peIter = peModel.getChildren(peModel.getModelRoot()).iterator();
				
				// for all processors
				while (peIter.hasNext()) {
					ModelNode peNode = peIter.next();
					if (!(peNode instanceof ProcessingElement)) {
						continue;
					}
					ProcessingElement pe = (ProcessingElement) peNode;
					Iterator<ModelNode> tIter = peModel.getChildren(pe).iterator();
				
					int pCount = 0;
					
					// for all threads
					while (tIter.hasNext()) {
						ModelNode tNode = tIter.next();
						if (!(tNode instanceof Thread)) {
							continue;
						}
						Thread t = (Thread) tNode;
						pCount += peModel.getChildCount(t);
					}
					pCounts.add(pCount);
				}
			}
		}
	}
	
}
