/**
 *
 * @file event.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: event.hh 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */


#ifndef SCTG_EVENT_HH
#define SCTG_EVENT_HH

#include "processing_element.hh"
#include "tg_token.hh"
#include "configuration.hh"

#include <systemc>
#include <boost/property_tree/ptree.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/optional.hpp>

#include <string>
#include <vector>

namespace sctg
{
   /** Creates timers to trigger tasks for execution
    */
   class Event : public sc_core::sc_module
   {
   public:
    
      SC_HAS_PROCESS(Event);

      /** Constructor
       */
      Event(sc_core::sc_module_name name, sctg::Configuration& config, 
	    const boost::property_tree::ptree& pt);

      /** Destructor
       */
      virtual ~Event();

      /** Thread
       */
      void thread();

      /** Maps event to a PE
       */
      void mapPe(ProcessingElement* pe);

      /** Returns out_port_id
       */
      unsigned long int getOutPort();

      /** How many times this event has been activated
       */
      unsigned long int getTimesHappened();

      /** Returns ID
       */
      unsigned long int getId();

      /** Returns name
       */
      std::string& getName();

   private:

      unsigned long int       _port;
      unsigned long int       _amount;
      std::string             _name;
      unsigned long int       _id;
      boost::optional<double> _offset;
      double                  _period;
      unsigned long int       _count;
      double                  _prob;

      unsigned long int       _timesHappened;

      std::vector<ProcessingElement*>  _owners;

      Configuration& _config;

      // Sends event tokens
      void send();          
    
   };

}
#endif



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
