///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : James Aldis (TI France)
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  Simple slave for example.
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef _SIMPLE_SLAVE_H
#define _SIMPLE_SLAVE_H

#include <map>

// OCP-IP Channel header files
#include "ocpip.h"
#include "slave_response_queue.h"

#include "MemoryCl.h"


// define the Slave class
template <unsigned int BUSWIDTH>
class Slave : public sc_core::sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,32>::DataType Td;
    typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,32>::AddrType Ta;
    typedef std::map< Ta, Td > MemMapType;

    // member definitions

    // channel port
    ocpip::ocp_slave_socket_tl1<BUSWIDTH> tpP;
    sc_core::sc_in_clk clk;

    // Systemc macros

    // has SystemC processes
    SC_HAS_PROCESS(Slave);

    // constructor and destructor
    Slave(sc_core::sc_module_name,
          int, Ta, std::ostream* debug_os_ptr = NULL);
    ~Slave();

    void requestThreadProcess();
    void responseThreadProcess();
    
    void set_configuration(const ocpip::ocp_parameters& , const std::string&);
    void setOCPTL1MasterTiming(ocpip::ocp_tl1_master_timing);
    void setModuleConfiguration(ocpip::map_string_type&); 

    tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time& t);

  private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // member definitions

    // slave identification
    int  m_ID;

    // ocp clock information
    sc_core::sc_time m_clkPeriod;

    // number of memory bytes and the memory array
    Ta   m_MemoryByteSize;

    // model a per thread response queue
    ResponseQueue<ocpip::ocp_data_class_unsigned<BUSWIDTH,32> > m_ResponseQueue;

    MemoryCl<ocpip::ocp_data_class_unsigned<BUSWIDTH,32> > *m_Memory;

    std::ostream* m_debug_os_ptr;

    // current value of SThreadBusy as set by this Slave.
    int m_curSThreadBusy;

    // ------------------------------------------------------------
    //  Parameters of the connected OCP channel
    // ------------------------------------------------------------
    
    // Number of threads in the OCP channel
    int m_threads;

    // Does the channel use data handshaking?
    bool m_datahandshake;

    // Are writes with responses part of the OCP channel?
    bool m_writeresp_enable;

    // is SThreadBusy part of the OCP channel?
    bool m_sthreadbusy;

    // do we follow the rules of sthread_busy exact?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the OCP channel?
    bool m_mthreadbusy;

    // is SCmdAccept part of the OCP channel?
    bool m_cmdaccept;

    // ------------------------------------------------------------
    //  Parameters of the Slave Model 
    // ------------------------------------------------------------

    // maximum number of outstanding requests per thread
    // default = 4;
    int m_limitreq_max;

    // Response Latency
    int m_Latency;

    ocpip::ocp_parameters m_parameters;

    sc_core::sc_time m_mthreadbusy_sample_time;
    tlm::tlm_generic_payload* m_req_txn;
    tlm::tlm_generic_payload* tb_txn;
    ocpip::thread_busy*       tb;
    tlm::tlm_phase tb_ph;
    unsigned int m_mtb;
    sc_core::sc_event resp_ack_event, req_event;
    
};

#endif // _SIMPLE_SLAVE_H

