// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Norman Weyrich, Synopsys Inc.
//                Anssi Haverinen, Nokia Inc.
//         $Id: ocp_tl1_globals.h,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : Global defines
//
// ============================================================================

// File contains two parts: 
//   - Part 1 is generic (for all Layers) and therefore should be included
//     only ones (in a mixed Layer simulation)
//   - Part 2 is Layer specific                      

//------------------------------------
// Layer independent global definitions

#ifndef _TL_GLOBALS_H
#define _TL_GLOBALS_H

#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <new>
#include "systemc.h"

#include "ocp_tl_param_cl.h"

const sc_time_unit TL_TIME_UNIT  = SC_NS; 
const double       TL_CLK_PERIOD = 1;     // clock period
const int          TL_SLAVE_FIFO_DEPTH = 10;

// Activation flag for timing output information
// #define DEBUG_S  // Slave timing
// #define DEBUG_S1 // Slave timing (response delay)
// #define DEBUG_C  // Channel timing
// #define TRACE_C  // Channel timing output into file
#define DEBUG_G1   // Output of request/response duration coming from
                   // Master, Bus, Slave modules

#endif // _TL_GLOBALS_H

//------------------------------------
// Layer-1 specific global definitions

#ifndef _TL1_GLOBALS_H
#define _TL1_GLOBALS_H

// Data class over which the modules are templatized
// The data class itself is templatized: DataCl<DataType, AddressType>
// DataType can be any e.g. int, sc_int<64>, sc_bigint<1024>,sc_bv<1024>,
// sc_lv<256>, ...
// AddressType must be either a native integer C++ type, or
// sc_int<>, sc_uint<>. E.g. int, long, sc_uint<64>, ...
#define TL1_TEMPL_DATA_CL OCP_TL1_DataCl<int, int >


#endif // _TL1_GLOBALS_H

