// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Architectural Transaction Level Modeling
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : declaration of simple OCP TL3 master,
//
// ============================================================================

#ifndef _OCP_TL3_MASTER_H
#define _OCP_TL3_MASTER_H

#include "ocp_tl3_master_port.h"  
#include "basic_protocol.h"

template <class Td, class Ta>
class ocp_tl3_master : public sc_module
{
  typedef basic_protocol::basic_request<Td,Ta>  requestType;
  typedef basic_protocol::basic_response<Td> responseType;
public:
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_master);
  
  // OCP-specific TL3 specialized master port 
  OCP_TL3_MasterPort<requestType,responseType> ocp;

  ocp_tl3_master(sc_module_name mod);
  ~ocp_tl3_master();
  void end_of_elaboration();

private:
  void send_request_method();
  void get_response_method();
  int m_sptr_req_gap;
  int m_sptr_resp_accept;
  Ta m_sptr_address;
  Td m_sptr_data;
  bool m_sptr_is_read;
  requestType m_req;
  responseType m_resp;
  int m_count_sent;
  int m_count_received;
};

#include "ocp_tl3_master.cc"

#endif // _OCP_TL3_MASTER_H
