// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: main.cc,v 1.5 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API -  TL1 AMBD profile example
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel_clocked.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

#ifdef PERF_MONITOR
#include "ocp_tl1_perf_monitor.h"
#endif

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // OCP channel declaration. Allows clocked blocking calls
  typedef  OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> data_type;
  typedef  OCP_TL1_Channel_Clocked< data_type > channel_type;
  channel_type ch0("ocp0");

  // Submodules
  Slave sl1("sl1");
  Master ms1("ms1");

  // Set OCP configuration
  ch0.setConfiguration(ocpParamMap);

  // netlist
  ch0.p_clk(clk);

  ms1.ipP(ch0);
  ms1.clk(clk);

  sl1.ipP(ch0);
  sl1.clk(clk);

#ifdef PERF_MONITOR
  // transaction recording monitor
  scv_tr_text_init();
  scv_tr_db db("ocp_db");
  scv_tr_db::set_default_db(&db);
  bool ChannelRecording = true;
  bool SystemRecording = false;
  bool BurstRecording = false;
  typedef OCP_Tl1_Perf_Monitor< data_type > perf_monitor_type;
  perf_monitor_type pmon0("pmon0",ChannelRecording,SystemRecording);
  pmon0.p_mon(ch0);
  pmon0.p_clk(clk);
#endif

  // Simulator
  sc_start(5000, SC_NS);
  
  return(0);
}
