// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//         Date : 06/10/2004
//  Description : Transaction Level - Layer-0 to Layer-1 Master Adapter (OCP 2.0)
//               (with Datahandshake support)
//
// ============================================================================

#ifndef _OCP_TL0_TL1_MASTER_ADAPTER_HS_H
#define _OCP_TL0_TL1_MASTER_ADAPTER_HS_H

#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_master_port.h"

template <class TdataCl> class OCP_TL0_TL1_Master_Adapter_Hs
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // TL1 Master Port
  OCP_TL1_MasterPort<TdataCl> MasterP;

  // TL0 Basic OCP Slave ports
  sc_in_clk             Clk;
  sc_in	  <sc_bv<3> >	MCmd;
  sc_in 	<Ta>      	MAddr;
  sc_out	<bool>	    SCmdAccept;

  sc_in 	<bool>	    MDataValid;
  sc_in 	<Td>      	MData;
  sc_out	<bool>	    SDataAccept;

  sc_out	<Td>      	SData;
  sc_out	<sc_bv<2> > SResp;
  sc_in 	<bool>	    MRespAccept;

  SC_HAS_PROCESS(OCP_TL0_TL1_Master_Adapter_Hs);

  // Default constructor: no need to specify explicit sampling times, use default ones
  OCP_TL0_TL1_Master_Adapter_Hs(sc_module_name name_
             , int ID
             , int Priority
             , bool Combinational
             , sc_time ClockCycle
             , bool Check_setup_time = true
            );

  // constructor with explicit sampling timings
   OCP_TL0_TL1_Master_Adapter_Hs(sc_module_name name_
             , int ID
             , int Priority
             , sc_time RequestSampleDelay = sc_get_time_resolution() 
             , sc_time RespAcceptSampleDelay = sc_get_time_resolution() 
             , bool Check_setup_time = true    
            );
 
  // destructor
  ~OCP_TL0_TL1_Master_Adapter_Hs();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void send_Request();
  void send_Data();
  void set_reset_SCmdAccept_PE();
  void set_SCmdAccept_Normal();
  void reset_SCmdAccept_Normal();
  void set_reset_SDataAccept_PE();
  void set_SDataAccept_Normal();
  void reset_SDataAccept_Normal();
  void reset_TL0_signals();
  void send_Response();
  void release_Response();
  void sample_events_trigger();
  void check_respaccept_setup_time();
  void check_request_setup_time();

private :

  void end_of_elaboration();
  
  // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;
  OCPDataHSGrp<Td>   TL1_dataHS ;
  
  // Pointer to the communication class of the channel
  CommCl           *m_CommCl;

  // Pointer to the parameter class of the channel
  ParamCl<TdataCl>           *m_ParamCl;

  // parameters
  sc_event e_request_sample_event;
  sc_event e_respaccept_sample_event;
  int m_ID; 
  int m_Priority;
  sc_time m_request_sample_delay;
  sc_time m_respaccept_sample_delay;
  bool m_check_active;
  sc_time m_last_rising_edge;
  bool m_default_values;
  bool m_response_in_progress;
  bool m_request_PE_mode;
  bool m_datahs_PE_mode;


  bool m_request_accepted;
  bool m_ready_for_request;
  bool m_datahs_accepted;
  bool m_ready_for_datahs;
};


#endif // _OCP_TL0_TL1_MASTER_ADAPTER_H
