// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: main.cc,v 1.5 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc"

// Include OCP files
#include "ocpip.h"
// Include user-defined headers
#include "command_line.h"



// Include submodules
#include "master.h"
#include "slave.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  map_string_type  ocpParamMap;
  std::string ocpParamFileName;

  sc_core::sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  

  // Submodules
  Slave sl1("sl1");
  Master ms1("ms1");

  // Set OCP configuration
  ocpip::ocp_parameters params;
  params=create_ocp_configuration_from_map("sl1", ocpParamMap);
  sl1.tpP.set_ocp_config(params);

  params=create_ocp_configuration_from_map("ms1", ocpParamMap);
  ms1.ipP.set_ocp_config(params);

#ifdef USE_OCP_MONITOR
  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece(ms1.ipP, sl1.tpP);
  ocpip::ocp_tl1_monitor_adapter<32,32> mon_adapt(ocp_monitor_t_piece);  
  ocpip_legacy::OCP_TL1_Trace_Monitor_Clocked<ocpip::ocp_data_class_unsigned<32,32> > tracer("Tracer", "ocp0.ocp");
  mon_adapt.assign_req_info_extension_to_bit_mask_cb(my_req_info_conv_to_bit);
  tracer.p_mon(mon_adapt);
  tracer.p_clk(clk);
#else
  ms1.ipP(sl1.tpP);
#endif

  ms1.clk(clk);
  sl1.clk(clk);

  // Simulator
  sc_core::sc_start(200, sc_core::SC_NS);
  sc_core::sc_stop();
  
  return(0);
}
