// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - Layer-2 Simple Example
//                Top level
//
// ============================================================================

// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl2_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl2_channel.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"


int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  OCP_TL2_Channel<OCPCHANNELBit32, OCPCHANNELBit32 > ch0("ocp0");

  // Submodules
  Slave<OCP_TL2_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > sl1("sl1");
  Master<OCP_TL2_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > ms1("ms1");

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  // Set parameters to channel
  ch0.setConfiguration(ocpParamMap);

  // Netlist
  ms1.ipP(ch0);

  sl1.tpP(ch0);

  // Simulator
  sc_start(50, SC_NS);

  return(0);
}
