// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - Layer-1 test Master
//    Features:
//    - Synchronous
//    - Non-blocking methods are used
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MData = 0;
  req.MAddr = 0;

  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Master<TdataCl>::proc() {

  // check if channel is free
  tmp = !ipP->getSBusy();
  if (tmp) {
    // Set OCP command type
    if ((cnt%5)==0)
      req.MCmd = OCP_MCMD_WR;
    else
      req.MCmd = OCP_MCMD_RD;
    
    // Send request
    tmp = ipP->startOCPRequest(req);
    if (tmp) {
      
#ifdef DEBUG_G1
      cout << "Master sent request " << req.MCmd
	   << " time " << sc_time_stamp().to_seconds();
      if (req.MCmd == OCP_MCMD_WR) {
	cout << " data " << req.MData;
	req.MData++;
      }
      cout << endl;
#endif
      
      req.MAddr += 4;
      cnt++;
    }
  }
  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {
#ifdef DEBUG_G1
      cout << "Master got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  data  = " << resp.SData << endl;
#endif
    }
  }
  
} // end of method





// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class Master< OCP_TL1_SIGNAL_CL >;

