// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : Generic API - Layer-2 simple pipelined Master
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MAddr = 0;

  // These must be threads since blocking calls are used
  SC_THREAD(proc_req);
  SC_THREAD(proc_resp);
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Master<TdataCl>::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc_req()
//
//  Master request process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Master<TdataCl>::proc_req() {
  req.MData = 0;

  while(true) {
    // Set OCP command type
    if ((cnt%5)==0)
      req.MCmd = OCP_MCMD_WR;
    else
      req.MCmd = OCP_MCMD_RD;
    
#ifdef DEBUG_G1
    cout << "Master sent request " << req.MCmd
	 << " time " << sc_time_stamp().to_seconds();
    if (req.MCmd == OCP_MCMD_WR) {
      cout << " data " << req.MData;
    }
    cout << endl;
#endif

    // Send request
    m_DataCl->MputMAddr(req.MAddr);
    if (req.MCmd == OCP_MCMD_WR) {
      m_DataCl->MputMData(&req.MData);
      tmp = ipP->MputWriteRequestBlocking();
      req.MData++;
    }
    else
      tmp = ipP->MputReadRequestBlocking();
    if (tmp) {
      req.MAddr += 4;
      cnt++;
    }
  }
} // end of method
  
// ----------------------------------------------------------------------------
//  Method : Master::proc_resp()
//
//  Master response process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Master<TdataCl>::proc_resp() {

  unsigned int size;
  bool release = true;
  bool last = true;
  sc_time delay = sc_time(2, SC_NS);
  int *sdata;
  while (true) {    
    // Check for response
    tmp = ipP->MgetResponseBlocking(release);
    if (tmp) {
      if (m_DataCl->MgetSResp() == OCP_SRESP_DVA) {
	// This pointer is safe until next wait() or blocking call
	sdata = m_DataCl->MgetSData(size, last);
#ifdef DEBUG_G1
	cout << "Master got valid response "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  data  = " << sdata[0] << endl;
#endif
	ipP->Mrelease(delay); // Release slave after a delay
      }
    }
  }
  
} // end of method


template<class TdataCl>
void Master<TdataCl>::end_of_elaboration()
{
  sc_module::end_of_elaboration();

  // Get data structure
  m_DataCl = ipP->GetDataCl();

  // Get OCP parameters, if needed by the master
  m_ParamCl = ipP->GetParamCl();
}


// ----------------------------------------------------------------------------
//
//  Instantiation of the Master
//
// ----------------------------------------------------------------------------
template class Master<OCP_TL2_DataCl< int, int >  >;

