// 
// Copyright 2003 OCP-IP
// OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Yann Bajot, Prosilog
//              : Alan Kamas, for Sonics, Inc.
//         Date : 09/09/2003
//
//  Description : OCP TL2 Slave port declaration.
//                These methods are implemented in the Channel
//                (see ocp_tl2_channel.h)
//
// ============================================================================

#ifndef OCP_TL2_SLAVEPORT_H
#define OCP_TL2_SLAVEPORT_H

#include "systemc/communication/sc_event_finder.h"
#include "ocp_tl2_slave_if.h"


template <class Tdata, class Taddr> class OCP_TL2_SlavePort
: public sc_port< OCP_TL2_SlaveIF<Tdata, Taddr> >
{
    public:

        // Constructor
        OCP_TL2_SlavePort(const char* name)
            : sc_port< OCP_TL2_SlaveIF<Tdata, Taddr> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the OCP TL2 Channel using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::RequestEndEvent ); }
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::ResponseEndEvent ); }

        // Access to the MThreadBusyEvent event of the OCP TL2 Channel using event finders
	sc_event_finder& MThreadBusyEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::MThreadBusyEvent ); }

        // Access to the Sideband events of the OCP TL2 Channel using event finders
	sc_event_finder& SidebandMasterEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandMasterEvent ); }
	sc_event_finder& SidebandResetEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandResetEvent ); }
	sc_event_finder& SidebandControlEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandControlEvent ); }
	sc_event_finder& SidebandStatusEvent() const { return *new sc_event_finder_t<OCP_TL2_SlaveIF<Tdata, Taddr> >( *this, &OCP_TL2_SlaveIF<Tdata, Taddr>::SidebandStatusEvent ); }

};

#endif   // OCP_TL2_SLAVEPORT_H

