// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stephane Guntz, PROSILOG, guntz@prosilog.com
//
//  Description : Layer Adapter, TL0-TL1 example, Synchronous TL0 OCP Slave 
//                with sequential 'SCmdAccept' signal
//  $Id: ocp_tl0_slave_sync2.h,v 1.1.1.1 2004/09/24 09:26:14 sguntz Exp $
//
// ============================================================================

#ifndef _TL0_OCP_SLAVE_SYNC2_H
#define _TL0_OCP_SLAVE_SYNC2_H

#define MEMORY_SIZE 255
#define REQUEST_FIFO_DEPTH 16   // '16' should be enough to take all input
                                                                    // signal glitches in one single cycle 

#include "systemc.h"
#include "ocp_globals.h"

using namespace std;

// ----------------------------------------------------------------------------
// Class : request_struct 
// 
// Description: internal structure used to store some OCP request information
// ----------------------------------------------------------------------------
template <class Td, class Ta> class request_struct {
  public:
    Td      mdata;
    Ta      maddr;
    int     mcmd;

};

template <class Td, class Ta> ostream& operator << (ostream& output, const request_struct<Td, Ta> input) {
  output << "Request Struct: " << endl;
  output << "MAddr: " << input.maddr << " MData: " << input.mdata << " MCmd: " << input.mcmd << endl;
  return output;
}

// ----------------------------------------------------------------------------
// Class : OCP_TL0_Slave_sync2 
// 
// Description: Synchronous TL0 OCP Slave 
// ----------------------------------------------------------------------------

template <class TdataCl> class OCP_TL0_Slave_sync2
  : public sc_module
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Basic OCP ports
  sc_in   <bool>      Clk;
  sc_in	  <sc_bv<3> >	MCmd;
  sc_in 	<Ta>      	MAddr;
  sc_in 	<Td>      	MData;
  sc_out	<bool>	    SCmdAccept;
  sc_out	<Td>      	SData;
  sc_out	<sc_bv<2> > SResp;
  sc_in 	<bool>	    MRespAccept;

  SC_HAS_PROCESS(OCP_TL0_Slave_sync2);

  // constructor
  OCP_TL0_Slave_sync2(sc_module_name name_
            , sc_time RequestDelay = sc_time(0)
            , sc_time ResponseDelay = sc_time(0)
           );

  // destructor
  ~OCP_TL0_Slave_sync2();

  // methods
  void MCmdThread();
  void SCmdAcceptSetThread();
  void SCmdAcceptResetThread();
  void ExecAndSendResponse();

  // Slave parameters
  sc_time   m_RequestDelay;
  sc_time   m_ResponseDelay;
  Td        m_memory[MEMORY_SIZE]; 
  sc_event  e_SCmdAccept_Set;
  sc_event  e_Request_present_delayed;
  sc_fifo<request_struct<Td,Ta> > m_request_fifo;

};


#endif // _TL0_OCP_SLAVE_SYNC2_H
