//////////////////////////////////////////////////////////////////////
//
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// Author: Herve Alexanian, Sonics, inc.
//
// $Id:
//
// Extended sc semaphore
//
//////////////////////////////////////////////////////////////////////

#ifndef _OcpipScSemaphore_h_
#define _OcpipScSemaphore_h_

#include "systemc.h"

namespace sc_extension
{

class ScSemaphoreInIf {
  public:
    virtual const sc_event& free_event() const = 0;
};

//! Extension of sc_semaphore with an accessor to the free event
class ScSemaphore : public sc_semaphore, public ScSemaphoreInIf {
  public:
    ScSemaphore( int init_value = 1 ) : sc_semaphore( init_value ) {}

    //! \brief Constructor
    //! \param name module name
    //! \param init_value number of slots in semaphore
    ScSemaphore( const char* name, int init_value = 1 ) :
        sc_semaphore( name, init_value ) {}
    ~ScSemaphore() {}

    //! Accesses the free event notified when the semaphore is released
    virtual const sc_event& free_event() const {
        return m_free;
    }
};

}

#endif /* _OcpipScSemaphore_h_ */
