// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: StlCommand.h,v 1.1 2007/01/25 22:09:07 halexan Exp $

#ifndef _OcpIp_StlCommand_h_
#define _OcpIp_StlCommand_h_

#include "IStl.h"
#include "ocp_globals.h"
#include "Params.h"
#include "OcpBundleDefs.h"
#include "BigInt.h"
#include "Memory.h"
#include <deque>

namespace OcpIp {
typedef ParamSet<int, ParamName> OcpParams;

class StlParser;
template<typename Td, typename Ta>
class StlParserTransferCommand : public StlTransferCommand<Td,Ta> {
  public:
    friend class StlParser;

    enum DataSpecType {
        NODATASPEC=0, NDATA, RDATA, CDATA, ADATA
    };
    enum DataInfoSpecType {
        NODATAINFOSPEC=0, NDI, RDI, CDI
    };

    typedef Td                  DataType;
    typedef snx_uint64_t        DataInfoType;
    typedef uint32_t            ByteEnType;
    typedef OCPTL2RequestGrp<Td, Ta> Request;

    StlParserTransferCommand( const OcpParams& params );
    int  ocpParam( ParamName index ) const {
        return m_ocpParams.getParam( index );
    }

  public:
    // underground accessors to interface members
    // these are public because the grammar needs access, and it's a nested
    // templated class which makes friendship difficult
    uint32_t&            _idleCycles() const {
        return const_cast<uint32_t&>( StlTransferCommand<Td,Ta>::idleCycles );
    }
    Request&             _request() const {
        return const_cast<Request&>( StlTransferCommand<Td,Ta>::request );
    }
    deque<DataType>&     _dataMask() const {
        return const_cast<deque<DataType>&>( StlTransferCommand<Td,Ta>::dataMask );
    }
    deque<DataInfoType>& _dataInfoMask() const {
        return const_cast<deque<DataInfoType>&>( StlTransferCommand<Td,Ta>::dataInfoMask );
    }

    DataType            m_currentData;
    DataType            m_currentDataMask;
    DataInfoType        m_currentDataInfo;
    DataInfoType        m_currentDataInfoMask;
    DataSpecType        m_currentDataSpec;
    DataInfoSpecType    m_currentDataInfoSpec;
    bool                m_randByteEn;
    uint32_t            m_transferWidth;  // for explicit with macros

    void addData    ( const DataType& data, const DataInfoType& dataInfo );
    void addData    ( const DataType& data, const DataInfoType& dataInfo,
                      const ByteEnType& byteen );
    void clear();

  private:
    const OcpParams&   m_ocpParams;
    DataInfoType*      m_pDataInfo;
    ByteEnType*        m_pByteEn;
    uint32_t           m_numDataReserved;
    uint32_t           m_defaultThreadId;
    void               reserve( uint32_t numData );
    // interface for the StlParser to build up data
    int                 m_dataIndex;
    int                 reportError( string& errors ) const;
    void                wrapup();
};

class StlParserWaitCommand : public StlWaitCommand {
  public:
    friend class StlParser;
    StlParserWaitCommand( const OcpParams& params );
    int  ocpParam( ParamName index ) const {
        return m_ocpParams.getParam( index );
    }

  public:
    // these are public because the grammar needs access, and it's a nested
    // templated class which makes friendship difficult
    Waiter         m_tmpWaiter;
    // underground accessors to interface class const members
    deque<Waiter>& _waiters() const {
        return const_cast<deque<Waiter>&>( waiters );
    }
    bool&          _andor() const {
        return const_cast<bool&>( andor );
    }
    void setAndOr( const char* first, const char* last ) {
        const string token( first, last );
        _andor() = ( token == "or" ) ? true : false;
    }

  private:
    void                clear();
    int                 reportError( string& errors ) const;
    void                wrapup();
    const OcpParams&    m_ocpParams;
};

class StlParserSignalCommand : public StlSignalCommand {
  public:
    friend class StlParser;
    StlParserSignalCommand( const OcpParams& params );
    int                ocpParam( ParamName index ) const {
        return m_ocpParams.getParam( index );
    }

  public:
    // underground accessors to interface class const members
    // these are public because the grammar needs access, and it's a nested
    // templated class which makes friendship difficult
    SignalName&         _signal() const {
        return const_cast<SignalName&>( signal );
    }
    bool&               _tbflags() const {
        return const_cast<bool&>( tbflags );
    }
    snx_uint64_t& _value() const {
        return const_cast<snx_uint64_t&>( value );
    }
    snx_uint64_t& _mask() const {
        return const_cast<snx_uint64_t&>( mask );
    }

  private:
    void                clear();
    int                 reportError( string& errors ) const;
    void                wrapup();
    const OcpParams&    m_ocpParams;
};

class StlParserResetCommand : public StlResetCommand {
  public:
    friend class StlParser;
    StlParserResetCommand( const OcpParams& params ) :
        m_ocpParams( params ) {}

    // public because the grammar needs access, and it's a nested
    // templated class which makes friendship difficult
  public:
    uint32_t& _resetCycles() const {
        return const_cast<uint32_t&>( resetCycles );
    }

  private:
    const OcpParams&   m_ocpParams;
};

class StlParserControlStatusCommand : public StlControlStatusCommand {
  public:
    friend class StlParser;
    StlParserControlStatusCommand( const OcpParams& params, bool coreSystem ) :
        m_ocpParams( params ), m_coreSystem( coreSystem ) {}
    int                ocpParam( ParamName index ) const {
        return m_ocpParams.getParam( index );
    }

    // public because the grammar needs access, and it's a nested
    // templated class which makes friendship difficult
  public:
    bool&          _controlStatus() const {
        return const_cast<bool&>( controlStatus );
    }
    bool&          _readWrite() const {
        return const_cast<bool&>( readWrite );
    }
    snx_uint64_t& _value() const {
        return const_cast<snx_uint64_t&>( value );
    }
    snx_uint64_t& _mask() const {
        return const_cast<snx_uint64_t&>( mask );
    }

  private:
    void                 clear();
    int                  reportError( string& errors ) const;
    void                 wrapup();
    const OcpParams&     m_ocpParams;
    bool                 m_coreSystem;
};

}

#endif /* _OcpIp_StlCommand_h_ */
