///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  This class converts the OCP TLM2 transfers into
//                 'old' style Req/Resp/DHS groups, so that an 'old' style
//                 monitor can analyze what is going on, as if it was looking
//                 at an 'old' style TL1 channel.
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_tl1_monitor_adapter.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION{

/*
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class ocp_tl1_monitor_adapter_data_cl{
public:
  typedef typename sc_dt::sc_bigint<BUSWIDTH> DataType; //normally one would use biguint, but there is a bug in the ostream operator...
  typedef sc_dt::uint64 AddrType;
};
*/

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class ocp_tl1_monitor_adapter 
  : public ocpip_legacy::OCP_TL1_MonitorIF<ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH> >
  , private OCPIP_VERSION::infr::ocp_observer_base
{
public:

  typedef ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH> data_class_type;
  typedef ocpip_legacy::OCP_TL1_MonitorIF<data_class_type>   mon_if_type;
  typedef typename mon_if_type::Td            Td;
  typedef typename mon_if_type::Ta            Ta;
  typedef typename mon_if_type::request_type  request_type;
  typedef typename mon_if_type::datahs_type   datahs_type;
  typedef typename mon_if_type::response_type response_type;
  typedef typename mon_if_type::paramcl_type  paramcl_type;

private:
  
  typedef ocp_tl1_legacy_convertion_helper< ocp_data_class_unsigned<BUSWIDTH, ADDRWIDTH>
                                          , ocp_tl1_monitor_adapter<BUSWIDTH, ADDRWIDTH> 
                                          , typename OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types>::ext_support_type
                                          , BUSWIDTH
                                          > converter_type;
  converter_type m_converter;

  struct mon_delay_info: public tlm_utils::instance_specific_extension<mon_delay_info> {
    bool fwNbw;
    bool callNreturn;
    tlm::tlm_sync_enum retVal;
  };
  
  ocp_peq<converter_type,false> m_peq;
  sc_core::sc_time m_null_time;
  void peq_cb(tlm::tlm_generic_payload&, const tlm::tlm_phase&);

  bool m_ocp_params_valid;
  ocpip_legacy::ParamCl<ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH> > m_ocp_params;

  request_type m_null_req;
  response_type m_null_rsp;
  datahs_type m_null_dhs;

  ocp_tl1_monitor_signal<request_type>  m_req_grp;
  ocp_tl1_monitor_signal<response_type> m_response_grp;
  ocp_tl1_monitor_signal<datahs_type>   m_datahs_grp;
  
  ocp_tl1_monitor_signal<bool>          m_req_grp_ack;
  ocp_tl1_monitor_signal<bool>          m_response_grp_ack;
  ocp_tl1_monitor_signal<bool>          m_datahs_grp_ack;
  
  ocp_tl1_monitor_signal<unsigned int>  m_mtb, m_stb, m_sdtb;
  mutable sc_core::sc_time m_cmd_trace_time, m_data_valid_trace_time, m_resp_trace_time;
  mutable ocpip_legacy::OCPMCmdType m_cmd_trace;
  mutable bool m_data_valid_trace;
  mutable ocpip_legacy::OCPSRespType m_resp_trace;
  
  unsigned int log2data;
  
  ocp_extension_pool<mon_delay_info> m_monInfoPool;
  
  ocpip_legacy::ParamCl<ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH> >& get_params();

  void nb_call_callback(bool fwNbw
                       ,tlm::tlm_generic_payload& txn
                       ,const tlm::tlm_phase& phase
                       ,const sc_core::sc_time& time);
                       
  void nb_return_callback(bool fwNbw
                         ,tlm::tlm_generic_payload& txn
                         ,const tlm::tlm_phase& phase
                         ,const sc_core::sc_time& time
                         ,tlm::tlm_sync_enum retVal);

  void b_call_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time);
  
  void b_return_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time);

public: 

  template <unsigned int BUSWIDTH_>
  ocp_tl1_monitor_adapter(OCPIP_VERSION::infr::monitor<BUSWIDTH_, tlm::tlm_base_protocol_types>& mon);
  
  // Monitor access
  virtual  const ocpip_legacy::OCPMCmdType getMCmdTrace () const ;
  virtual  const bool getMDataValidTrace ()  const ;
  virtual  const ocpip_legacy::OCPSRespType getSRespTrace () const ;

  // port names
  virtual const std::string		peekChannelName()const	;
  virtual const std::string		peekMasterPortName()const ;
  virtual const std::string		peekSlavePortName()const ;

  // transactions
  virtual const request_type&	peekOCPRequest()	const ;
  virtual const datahs_type&	peekDataHS()		const ;
  virtual const response_type&	peekOCPResponse()	const ;


  virtual const bool		peekRequestEnd()	const ;
  virtual const bool		peekRequestStart()	const ;
  virtual const bool		peekRequestEarlyEnd()	const ;
  
  virtual const bool		peekResponseEnd()	const ;
  
  virtual const bool		peekResponseStart()	const ;
  virtual const bool		peekResponseEarlyEnd()	const ;

  virtual const bool		peekDataRequestEnd()	const ;
  virtual const bool		peekDataRequestStart()	const ;
  virtual const bool		peekDataRequestEarlyEnd() const ;

  // thread busy 
  virtual const unsigned int	peekSThreadBusy()	const ;
  virtual const unsigned int	peekSDataThreadBusy()	const ;
  virtual const unsigned int	peekMThreadBusy()	const ;

  // reset
  virtual const bool		peekMReset_n()		const ;
  virtual const bool		peekSReset_n()		const ;

  // sideband signals
  virtual const bool		peekMError()		const ;
  virtual const unsigned int	peekMFlag()		const ;
  virtual const bool		peekSError()		const ;
  virtual const unsigned int	peekSFlag()		const ;
  virtual const bool		peekSInterrupt()	const ;
  virtual const unsigned int	peekControl()		const ;
  virtual const bool		peekControlWr()		const ;
  virtual const bool		peekControlBusy()	const ;
  virtual const unsigned int	peekStatus()		const ;
  virtual const bool		peekStatusRd()		const ;
  virtual const bool		peekStatusBusy()	const ;
  virtual const bool		peekExitAfterOCPMon()	const ;
    
  void error(const char* func) const ;

  // OCP paramertes
  virtual paramcl_type*		GetParamCl()		      ;
};
}

#include __MACRO_STRINGYFY__(../mon/src/OCPIP_VERSION/ocp_tl1_monitor_adapter.tpp)
