///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP master model driven by STL
//                 stimulus for use in TL1 modeling examples. Uses TL3 model +
//                 TL3/TL1 adapter
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "generic_stl_master_tl1.h"

template<unsigned int BUSWIDTH>
ocpip_example::generic_stl_master_tl1<BUSWIDTH>::generic_stl_master_tl1( sc_core::sc_module_name nm ) :
    sc_core::sc_module( nm )
    , m_socket   ( "socket"    )
    , m_clk      ( "clk"       )
    , m_model    ( basename()  )  // pass the same name as it will be used to find STL streams
    , m_adapter  ( "adapter"   )
{    
    m_adapter.tl1_socket.make_generic();
    m_adapter.tl1_socket( this->m_socket );
    m_socket.register_configuration_listener_callback(this, &generic_stl_master_tl1<BUSWIDTH>::propagate_config);

    m_adapter.slave_socket.make_generic();
    m_model.m_socket.make_generic();
    m_model.m_socket( m_adapter.slave_socket );
    m_adapter.clk(m_clk);

    // TODO: make user level control for delays
    m_adapter.set_delay_obj( tlm::BEGIN_REQ, ocpip::phase_delay_basic_burst_calc<uint32_t>( 0, 1 ) );
    m_adapter.set_delay_obj( ocpip::BEGIN_DATA, ocpip::phase_delay_basic_burst_calc<uint32_t>( 4, 0 ) );
}

template<unsigned int BUSWIDTH>
void
ocpip_example::generic_stl_master_tl1<BUSWIDTH>::propagate_config( const ocpip::ocp_parameters& conf, const std::string& )
{
    m_model.m_socket.set_ocp_config( conf );    
    m_adapter.slave_socket.set_ocp_config( conf );    
}
