// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//         $Id: slave.h,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : OCP - TL1 example Slave
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

//#define DEBUG_G1

#include <iostream>


// OCP-IP Channel header files
#include "ocpip.h"

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH>
class Slave : public sc_core::sc_module {
public:  

  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::DataType Td;
  typedef typename ocpip::ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::AddrType Ta;

  ocpip::ocp_slave_socket_tl1<sizeof(Td)*8> tpP;

  sc_core::sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_core::sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);
  // OCP request group
  tlm::tlm_generic_payload* req;
  bool ongoing_rsp;
  tlm::tlm_generic_payload* rsp;
  tlm::tlm_phase phase;
  sc_core::sc_time time;
  unsigned int dataCnt;
  tlm::tlm_command last_request;

};

#endif
