// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_core::sc_module_name name_): 
  sc_core::sc_module (name_), ipP("ipPort", ocpip::ocp_master_socket_tl1<32>::mm_txn_with_data()) , ongoing_req(false), inreset(false), resp(NULL){

  // initialize common members
  cnt = 0;
  req=NULL;
  localData = 0;
  addr = 0;
  read = false;
  burstcnt = 0;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {
  if (inreset){
    if(++cnt==16){ //we waited long enough
      cnt=0;
      burstcnt=0;
      addr=0;
      read=false;
      ongoing_req=false;
      if (resp) resp=NULL;
      expected_rsps.clear();
      inreset=false;
      phase=ocpip::END_RESET;
      tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*ipP.get_reset_transaction(), phase, time);
      
      //we are at the effective time of the end of reset AND after the call that ends the reset
      // so we can now perform the end-of-transaction activity
      if (req) {ipP.release_transaction(req); req=NULL;}     
      assert(retVal==tlm::TLM_ACCEPTED);      
    }
    return;
  }


  // check if channel is free
  if (!ongoing_req) {
    // Set OCP command type
    if ((cnt%16)==0 | (cnt%16)==8){
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, 8*sizeof(Td));
      req->set_command((read)?tlm::TLM_READ_COMMAND:tlm::TLM_WRITE_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::burst_length* b_len;
      ipP.get_extension<ocpip::burst_length>(b_len, *req);
      b_len->value=8;
      ipP.validate_extension<ocpip::burst_length>(*req);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(8*sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
      if (read)
        req->set_address(addr & (~0x20)); // write and read same addresses
      else
        req->set_address(addr);
      if (req->get_command() == tlm::TLM_WRITE_COMMAND){
        ipP.validate_extension<ocpip::posted>(*req);
        for (int i=0; i<8; i++)
          *(((Td*)(req->get_data_ptr()))+i)=localData++;
      }
    }
    if (read) {
      if (burstcnt==7) {
        read = false;
        burstcnt=0;
      }
      else {
        burstcnt++;
      }
    } 
    else {
      if (burstcnt==7) {
        read = true;
        burstcnt=0;
      }
      else {
        burstcnt++;
      }	
    }
    
    if (cnt%32==27){
      time=sc_core::SC_ZERO_TIME;
      phase=ocpip::BEGIN_RESET;
      tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*ipP.get_reset_transaction(), phase, time);
      assert(retVal==tlm::TLM_ACCEPTED);
      inreset=true;
      cnt=0;
      return; //we just started reset, so we leave
    }
    
    // Send request
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::BEGIN_REQ;
    tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
#ifdef DEBUG_G1
    std::cout << "Master sent request " << req->get_command()
     << " time " << sc_core::sc_time_stamp().to_seconds();
    if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
      std::cout <<" "<<burstcnt<<" data " << (*(((Td*)(req->get_data_ptr()))+(((burstcnt)?burstcnt:8)-1)));
    }
    std::cout << std::endl;
#endif

    if (req->get_command()==tlm::TLM_READ_COMMAND){
      expected_rsps.push_back(expected_rsp(req, (((burstcnt)?burstcnt:8)-1), burstcnt==0));
    }
    
    switch(retVal){
      case tlm::TLM_ACCEPTED: ongoing_req=true; break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_REQ:
            if (!read && burstcnt==0) {ipP.release_transaction(req); req=NULL;}//we are done since there are no write resps
            break;
          default:
            std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_REQ."<<std::endl;
            exit(1);                
        }
        break;
      case tlm::TLM_COMPLETED:;
    }
    
    
    // Address generator
    if (addr < 124)
      addr += 4;
    else
      addr = 0;
    cnt++;
  }
  
  // Check for response
  if (resp) {
    assert(resp==expected_rsps.front().txn);
#ifdef DEBUG_G1
    if (resp->get_response_status() == tlm::TLM_OK_RESPONSE) {
      std::cout << "Master got valid response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*(((Td*)(resp->get_data_ptr()))+expected_rsps.front().chunk)) << std::endl;
    }
    else{
      std::cout << "Master got error response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*(((Td*)(resp->get_data_ptr()))+expected_rsps.front().chunk)) << std::endl;
    }
#endif    
    if (expected_rsps.front().last) {
      ipP.release_transaction(resp); //we are done with this txn now
    }
    resp=NULL;
    expected_rsps.pop_front();
  }
  
} // end of method

tlm::tlm_sync_enum Master::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      if (txn.get_command()==tlm::TLM_WRITE_COMMAND && burstcnt==0) {
        ipP.release_transaction(req); //we are done since there are no write resps
        req=NULL;
      }
      break;
    case tlm::BEGIN_RESP: resp=&txn;
      ph=tlm::END_RESP;
      return tlm::TLM_UPDATED; //there is no resp accept control flow
      break;
    default:
      std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
      exit(1);
  }
  return tlm::TLM_ACCEPTED;
}
