// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//         Date : 02/15/2003
//
//  Description : Transaction Level - Layer-1 example Master
//
// ============================================================================


#ifndef _OCP_TL1_MASTER_H
#define _OCP_TL1_MASTER_H

#include "ocp_tl1_globals.h"
#include "tl_master_if.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl_tl1> class OCP_TL1_Master
  : public sc_module
  , public MdirectIF<TdataCl_tl1>
{
public:  
  
  typedef typename TdataCl_tl1::DataType Td;
  typedef typename TdataCl_tl1::AddrType Ta;

  sc_port<TLmasterIF<TdataCl_tl1>, 1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master);

  // constructor
  OCP_TL1_Master(sc_module_name name_
             , int ID
             , int Priority
             , double DelayPct
            );

  // destructor
  ~OCP_TL1_Master();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl_tl1          *m_DataCl;
  ParamCl<TdataCl_tl1> *m_ParamCl;
  CommCl				*m_CommCl;

  // parameters
  int m_ID;
  int m_Priority;
  double m_DelayPct;
};


#endif // _OCP_TL1_MASTER_H