// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Joe Chou, Sonics Inc., joechou@sonicsinc.com 
//         Date : 03/31/2003
//
//  Description : Transaction Level Master interface declaration.
//                These methods are implemented in the Channel
//                (see tl_channel.h)
//
// ============================================================================

#ifndef _TL_MASTER_IF
#define _TL_MASTER_IF

#include "systemc.h"

// forward declaration for parameter class
template <class TdataCl> class ParamCl;

#include "tl_comm_cl.h"
#include "tl_direct_if.h"

template <class TdataCl> class TLmasterIF
  : public MdirectIF<TdataCl>
{
  public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Methods to initiate requests and get responses.
  virtual void Mrelease() = 0;
  virtual void MreleasePE() = 0;
  virtual void Mrelease(sc_time) = 0;
  virtual bool MputRequest() = 0;
  virtual bool MputWriteRequest() = 0;
  virtual bool MputWriteRequestBlocking() = 0;
  virtual bool MputReadRequest() = 0;
  virtual bool MputReadRequestBlocking() = 0;
  virtual bool MgetResponse(bool) = 0;
  virtual bool MgetResponseBlocking(bool) = 0;
  virtual bool MgetResponsePE() = 0;
  virtual bool MgetSbusy() = 0;

  // Second request channel (data handshake)
  virtual bool MputDataRequest() = 0;
  virtual bool MputDataRequestBlocking() = 0;
  virtual bool MgetSbusyData() = 0;

  // This event is triggered if an Mput or an Sput method is called
  // in the Channel connected to the Master.
  virtual const sc_event& default_event() const = 0;

  // Access methods to the user defined data structures of the Channel.
  virtual TdataCl          *GetDataCl()  = 0;
  virtual ParamCl<TdataCl> *GetParamCl() = 0;
  virtual CommCl           *GetCommCl()  = 0;

  // Direct access method Master to Slave direction.
  virtual bool MputDirect(int, bool, Td*, Ta, int) = 0;
  virtual void MregisterDirectIF(MdirectIF<TdataCl>*) = 0;

};

#endif // _TL_MASTER_IF
