// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexandrian, Sonics
//         $Id: tl1_Slave.h,v 1.1 2006/01/30 22:12:12 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================



#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"

SC_MODULE(tl1_Slave) {

  OCP_TL1_SlavePort<OCP_TL1_DataCl<DType, AType > > ipP;

  // TL1 clock
  sc_in_clk  Clk;

  SC_HAS_PROCESS(tl1_Slave);

  tl1_Slave (sc_module_name name_)
    : sc_module (name_), ipP("ipPort") {
    
    // initialize common members
    is_req = false;
    tmp = false;
    resp.SResp = OCP_SRESP_NULL;
    resp.SData = 0;
    last_request = OCP_MCMD_IDLE;
    
    SC_METHOD(proc);
    sensitive_pos(Clk);
    dont_initialize(); // make sure we execute only at clock edge
  }


  // Dummy slave
  void proc(){

    // If a previous read has been served, we check for new requests
    if (last_request != OCP_MCMD_RD) {
      is_req = ipP->getOCPRequest(req, true); // accept automatically
      if (is_req)
	last_request = req.MCmd;
    }
    
    // If request was write
    if (last_request == OCP_MCMD_WR) {
      last_request = OCP_MCMD_IDLE;
    }
    else if (last_request == OCP_MCMD_RD) {
      tmp = ipP->getMBusy();
      if (!tmp) {
	// Set OCP response
	resp.SResp = OCP_SRESP_DVA;
	// Send response
	ipP->startOCPResponse(resp);
	resp.SData++;
	last_request = OCP_MCMD_IDLE;
      }
    } // end if (last_request)
  } // end of method

  // OCP request group
  OCPRequestGrp<DType,AType> req;

  // OCP response group
  OCPResponseGrp<DType> resp;

  bool is_req;
  bool tmp;
  int last_request;
};

#endif

