/*
  James Aldis
  TI France
  OCP TL1 Channel Timing Distribution
  29 June 2005

  C++ Header File for:
    common typedefs and stuff for TL1 timing test
*/


// multiple inclusion protection
#ifndef TL1_TIMING_COMMON_H
#define TL1_TIMING_COMMON_H


#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_data_cl.h"
// #include "ocp_tl1_channel.h"
#include "ocp_tl1_channel_clocked.h"

typedef int OCP_D;
typedef int OCP_A;
typedef OCP_TL1_MasterPort<OCP_TL1_DataCl<OCP_D, OCP_A> > OCP_MASTER_PORT;
typedef OCP_TL1_SlavePort<OCP_TL1_DataCl<OCP_D, OCP_A> > OCP_SLAVE_PORT;
typedef OCPRequestGrp<OCP_D, OCP_A> OCP_REQ;
typedef OCPResponseGrp<OCP_D> OCP_RESP;
// typedef OCP_TL1_Channel<OCP_TL1_DataCl<OCP_D, OCP_A> > OCP_TL1_CHANNEL;
typedef OCP_TL1_Channel_Clocked<OCP_TL1_DataCl<OCP_D, OCP_A> > OCP_TL1_CHANNEL;


double unit_rand() {
  return(double(random() & 0xFFFFFF)/double(0xFFFFFF));
}


// end of multiple inclusion protection
#endif

