#############################################################
# TGI Starts
#############################################################

my $DSG_ID      = getDesignID("false");
my $design_name = getName($DSG_ID);
my @DSG_VLNV    = getDesignVLNV ($DSG_ID);

print "Design VLNV is @DSG_VLNV\n";

getCompArea($DSG_ID);

#############################################################

sub getCompArea {
    $design_id = shift; 

    # get all the instances ID - getDesignComponentInstanceIDs
    @INSTs_IDs = getDesignComponentInstanceIDs($design_id);
    return "NO INSTANCES FOUND" if (!defined @INSTs_IDs);

    ## open the report file
    open RPT, "> area.rpt" or die $!;
    print RPT "Report of Design Instances\n";

    ## loop through the instances to collect the gateArea if any
    foreach $instance_id (@INSTs_IDs) {
      $INSTANCE_NAME      = getComponentInstanceName($instance_id);
      @INSTANCE_VLNV      = getComponentInstanceVLNV($instance_id);
      $master_id          = getComponentInstanceComponentID($instance_id);
      $INSTANCE_COMP_NAME = getName($master_id);
      $INSTANCE_NAME_MISC = getName($instance_id);
      $COMP_TYPE          = getComponentElementType($master_id);

      print RPT "\nComponent Name   - $INSTANCE_COMP_NAME\n";
      print RPT "\n\tInstance Name  - $INSTANCE_NAME\n";
      print RPT "\tInstance VLVN  - @INSTANCE_VLNV\n";
      print RPT "\tComponent Type - $COMP_TYPE\n";

      $comp_area = 0;
      ## loop through the views to find accellera-pdp:gateArea
      @VIEWs_IDs = getComponentViewIDs($master_id,false);
      
          foreach $vue (@VIEWs_IDs) {
            @VENDOR_EXTENSION  = getVendorExtensions($vue);
            $this_statement = 0;
            while (<@VENDOR_EXTENSION>) {
              if (/accellera-pdp:gateArea/ && $this_statement == 0 ) {
                $this_statement = 1;
    	        next;
              }
              if (/&amp;gt;(.*)&amp;lt;/ && $this_statement == 1) {
                $comp_area = $1;
		print RPT "\tComponent Area - $comp_area\n";
                $this_statement = 0;
              }
    	    }
          }
  }
   return true;
}
