// This *.f file is meant to be run in the xrun_ams_sim directory
-64
-timescale 1ns/1fs
-access=rw+/.
-suppress vopt-2732
// options
-uvm
+UVM_VERBOSITY=UVM_MEDIUM
+UVM_TESTNAME=default_sequence_ms_test

// include directories
-incdir ../../uvc_lib/osc/sv/
-incdir ../../uvc_lib/registers/sv/
-incdir ../../includes/

// compile files
../../includes/uvm_ms_pkg.sv
../../uvc_lib/osc/sv/osc_pkg.sv
../../uvc_lib/i2c/sv/state_vars_pkg.sv
../../uvc_lib/i2c/sv/i2c_pkg.sv

// Analog resource
// for Analog DUT
../../uvc_lib/osc/sv/osc_bridge.sv
../../uvc_lib/osc/vams/osc_bridge_core.vams

// virtual interfaces
../../uvc_lib/osc/sv/osc_if.sv
../../uvc_lib/i2c/sv/i2c_if.sv

// DUT
-incdir ../../src_vams/
../../src_vams/ana_buf.vams
../../src_vams/clk_driver_diff.vams
../../src_vams/frequency_adapter.vams
../../src_vams/freq_div2.vams
../../src_vams/freq_doubler.vams
../../src_vams/mux4to1.vams
../../src_dig/I2C_target.sv
../../src_dig/I2C_registers.sv

-define UVM_AMS
-incdir ../
../top.sv
-top top
+SVSEED=random

//-coverage U -covoverwrite
//-input probes.tcl


//RNM Coercion is used to change the nettypes of top.{clk_in,clkout_p, clkout_n} from "wire" to "wreal4state"
//This is a Cadence Xcelium Mixed Signal App feature, and for non-Cadence simulators, will need either:
//* an equivalent feature to coercion, OR
//* an update to the ../top.sv and ../../uvc_lib/osc/sv/osc_bridge.sv files
-do "run -all; exit -f"
-rnmautointerconnect
-debug
-qwavedb=+memory+signal+msgmode+displaymsgmode+flushtime=1+class+classmemory+uvm_schematic
