// A frequency divider module
`timescale 1ns/1fs
`ifdef XRUN
import cds_rnm_pkg::*;
`endif

`ifdef VCS
import snps_msv_nettype_pkg::*;
`endif


module freq_div2 (
	clk_in,
	clk_out);
	
	input wreal4state clk_in;
	output wreal4state clk_out;
	
	parameter real vsup = 1.8;    //Supply voltage for clock signal (V)
  parameter real vth = vsup/2;  //Threshold voltage for clock signal transition 
  	
	real clk_out_int;
	

	initial begin
		clk_out_int = 0;
	end
	
	
	always @ (posedge (clk_in > vth))begin
		clk_out_int = (clk_out_int==0) ? vsup : 0; 
	end
	
	assign clk_out = clk_out_int;
	
endmodule
